/*
 * Decompiled with CFR 0.152.
 */
package entities.creatures.player;

import core.GameWindow;
import core.Sprite;
import core.states.GameState;
import entities.Entity;
import entities.creatures.EnemyCreatureEntity;
import entities.creatures.PlayerCreatureEntity;
import entities.missiles.sona.SonaAbilityQEntity;
import entities.missiles.sona.SonaAbilityREntity;
import entities.missiles.sona.SonaShotEntity;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Random;
import util.Config;
import util.ResourceManager;

public final class SonaEntity
extends PlayerCreatureEntity {
    private char lastQWEAbility;
    private int powerChordCount;
    private long lastPowerChordETime;
    private long lastAbilityQWETime;
    private long lastNoteAnimationTime;
    private Sprite abilityWParticle;
    private Sprite abilityWParticle2;
    private Sprite abilityEParticle;
    private Sprite abilityEParticle2;
    private int noteX1;
    private int noteX2;
    private int noteX3;
    private int noteY1;
    private int noteY2;
    private int noteY3;
    private Random random;

    public SonaEntity(GameState game, int x, int y) {
        super(game, "creatures/sona", x, y);
        this.entityIcon = ResourceManager.get().getSprite("icons/sona/creature");
        this.passiveIconActive = ResourceManager.get().getSprite("icons/sona/passiveActive");
        this.abilityQIconActive = ResourceManager.get().getSprite("icons/sona/abilityQActive");
        this.abilityWIconActive = ResourceManager.get().getSprite("icons/sona/abilityWActive");
        this.abilityEIconActive = ResourceManager.get().getSprite("icons/sona/abilityEActive");
        this.abilityRIconActive = ResourceManager.get().getSprite("icons/sona/abilityRActive");
        this.abilityDIconActive = ResourceManager.get().getSprite("icons/sona/abilityDActive");
        this.abilityFIconActive = ResourceManager.get().getSprite("icons/sona/abilityFActive");
        this.passiveIconPassive = ResourceManager.get().getSprite("icons/sona/passivePassive");
        this.abilityQIconPassive = ResourceManager.get().getSprite("icons/sona/abilityQPassive");
        this.abilityWIconPassive = ResourceManager.get().getSprite("icons/sona/abilityWPassive");
        this.abilityEIconPassive = ResourceManager.get().getSprite("icons/sona/abilityEPassive");
        this.abilityRIconPassive = ResourceManager.get().getSprite("icons/sona/abilityRPassive");
        this.abilityDIconPassive = ResourceManager.get().getSprite("icons/sona/abilityDPassive");
        this.abilityFIconPassive = ResourceManager.get().getSprite("icons/sona/abilityFPassive");
        this.passiveIcon = this.passiveIconPassive;
        this.abilityQIcon = this.abilityQIconActive;
        this.abilityWIcon = this.abilityWIconActive;
        this.abilityEIcon = this.abilityEIconActive;
        this.abilityRIcon = this.abilityRIconActive;
        this.abilityDIcon = this.abilityDIconActive;
        this.abilityFIcon = this.abilityFIconActive;
        this.abilityWParticle = ResourceManager.get().getSprite("particles/sona_abilityW");
        this.abilityWParticle2 = ResourceManager.get().getSprite("particles/sona_abilityW2");
        this.abilityEParticle = ResourceManager.get().getSprite("particles/sona_abilityE");
        this.abilityEParticle2 = ResourceManager.get().getSprite("particles/sona_abilityE2");
    }

    @Override
    protected void set() {
        super.set();
        this.random = new Random();
        this.lastNoteAnimationTime = 0L;
        this.lastAbilityQWETime = 0L;
        this.lastPowerChordETime = 0L;
        this.powerChordCount = 0;
        this.setHitpoints(Config.get(Config.sonaHitpoints) + Config.get(Config.sonaHitpointsPerLevel) * this.game.getLevel());
        this.setMoveSpeed(Config.get(Config.sonaMoveSpeed));
        this.shotCooldown = Math.max(Config.get(Config.sonaShotCooldown) - Config.get(Config.sonaShotCooldownPerLevel) * this.game.getLevel(), Config.get(Config.sonaShotCooldownCap));
        this.abilityQCooldown = Math.max(Config.get(Config.sonaAbilityQCooldown) - Config.get(Config.sonaAbilityQCooldownPerLevel) * this.game.getLevel(), Config.get(Config.sonaAbilityQWECooldown));
        this.abilityWCooldown = Math.max(Config.get(Config.sonaAbilityWCooldown), Config.get(Config.sonaAbilityQWECooldown));
        this.abilityECooldown = Math.max(Config.get(Config.sonaAbilityECooldown), Config.get(Config.sonaAbilityQWECooldown));
        this.abilityRCooldown = Math.max(Config.get(Config.sonaAbilityRCooldown) - Config.get(Config.sonaAbilityRCooldownPerLevel) * this.game.getLevel(), Config.get(Config.sonaAbilityRCooldownCap));
        this.abilityDCooldown = Config.get(Config.sonaAbilityDCooldown);
        this.abilityFCooldown = Config.get(Config.sonaAbilityFCooldown);
    }

    public boolean isPowerChordWActive() {
        return this.getPowerChordWTime() > 0L;
    }

    public boolean isPowerChordEActive() {
        return this.getPowerChordETime() > 0L;
    }

    public long getPowerChordWTime() {
        if (!this.hasEffect("bufferDiminuendo")) {
            return 0L;
        }
        return this.getEffectDuration("bufferDiminuendo") - this.game.getTime();
    }

    public long getPowerChordETime() {
        return Math.max(this.lastPowerChordETime + (long)Config.get(Config.sonaAbilityEDuration) - this.game.getTime(), 0L);
    }

    public void setLastPowerChordETime(long time) {
        this.lastPowerChordETime = time;
    }

    @Override
    public void damage(Entity entity, int damage) {
        if (this.hasEffect("bufferDiminuendo")) {
            damage = (int)((double)damage * Config.get(Config.sonaPowerChordWMultiplier));
        }
        super.damage(entity, damage);
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        if (!this.canMove()) {
            return;
        }
        if (this.dx < 0.0 && this.x <= 0.0) {
            this.x = 0.0;
        }
        if (this.dx > 0.0 && this.x >= ResourceManager.get().getDimension().getWidth() - (double)this.getW()) {
            this.x = ResourceManager.get().getDimension().getWidth() - (double)this.getW();
        }
    }

    @Override
    public void notifyDeath() {
        ResourceManager.get().playSound("sona_die", true);
        this.game.playerDead();
    }

    @Override
    protected void shot() {
        SonaShotEntity shot = new SonaShotEntity(this, this.game, (int)this.x + this.getW() / 2 - 5, (int)this.y + this.getH() / 2 - 30);
        if (this.powerChordCount >= 3) {
            shot.setPowerChord(this.lastQWEAbility);
            this.powerChordCount = 0;
            ResourceManager.get().playSound("sona_powerchord");
        } else {
            ResourceManager.get().playSound("sona_shot");
        }
        this.game.addEntity(shot);
    }

    @Override
    protected void abilityQ() {
        this.lastAbilityQWETime = this.game.getTime();
        SonaAbilityQEntity shot = new SonaAbilityQEntity(this, this.game, (int)this.x + this.getW() / 2 - 6 - 20, (int)this.y + this.getH() / 2 - 23);
        this.game.addEntity(shot);
        shot = new SonaAbilityQEntity(this, this.game, (int)this.x + this.getW() / 2 - 6 + 20, (int)this.y + this.getH() / 2 - 23);
        this.game.addEntity(shot);
        ++this.powerChordCount;
        if (this.powerChordCount == 3) {
            this.lastShotTime = 0L;
        }
        this.lastQWEAbility = (char)81;
        ResourceManager.get().playSound("sona_abilityQ");
    }

    @Override
    protected void abilityW() {
        this.lastAbilityQWETime = this.game.getTime();
        this.heal(Config.get(Config.sonaAbilityWHealAmount) + Config.get(Config.sonaAbilityWHealAmountPerLevel) * this.game.getLevel());
        ++this.powerChordCount;
        if (this.powerChordCount == 3) {
            this.lastShotTime = 0L;
        }
        this.lastQWEAbility = (char)87;
        ResourceManager.get().playSound("sona_abilityW");
    }

    @Override
    protected void abilityE() {
        this.lastAbilityQWETime = this.game.getTime();
        this.addMoveSpeedMultiplier(Config.get(Config.sonaAbilityEMoveSpeedMultiplier) + Config.get(Config.sonaAbilityEMoveSpeedMultiplierPerLevel) * (double)this.game.getLevel(), this.lastAbilityQWETime + (long)Config.get(Config.sonaAbilityEDuration));
        this.refreshMoveSpeed();
        ++this.powerChordCount;
        if (this.powerChordCount == 3) {
            this.lastShotTime = 0L;
        }
        this.lastQWEAbility = (char)69;
        ResourceManager.get().playSound("sona_abilityE");
    }

    @Override
    protected void abilityR() {
        SonaAbilityREntity shot = new SonaAbilityREntity(this, this.game, (int)this.x + this.getW() / 2 - 32, (int)this.y + this.getH() / 2 - 69);
        this.game.addEntity(shot);
        ResourceManager.get().playSound("sona_abilityR");
    }

    @Override
    protected void abilityD() {
        this.heal(Config.get(Config.sonaAbilityDHealAmount) + Config.get(Config.sonaAbilityDHealAmountPerLevel) * this.game.getLevel());
        this.addEffect("healHeal", this.game.getTime() + 1500L);
        ResourceManager.get().playSound("sona_abilityD");
    }

    @Override
    protected void abilityF() {
        if (this.isStunned() || this.dx == 0.0 || this.x == 0.0 || this.x == ResourceManager.get().getDimension().getWidth() - (double)this.getW()) {
            this.lastAbilityFTime = 0L;
            return;
        }
        if (this.dx < 0.0) {
            this.x -= (double)Config.get(Config.sonaAbilityFDistance);
        } else if (this.dx > 0.0) {
            this.x += (double)Config.get(Config.sonaAbilityFDistance);
        }
        if (this.x < 0.0) {
            this.x = 0.0;
        } else if (this.x > ResourceManager.get().getDimension().getWidth() - (double)this.getW()) {
            this.x = ResourceManager.get().getDimension().getWidth() - (double)this.getW();
        }
        ResourceManager.get().playSound("sona_abilityF");
    }

    @Override
    public long getAbilityQCooldown() {
        return Math.max(super.getAbilityQCooldown(), Math.max(this.lastAbilityQWETime + (long)Config.get(Config.sonaAbilityQWECooldown) - this.game.getTime(), 0L));
    }

    @Override
    public long getAbilityWCooldown() {
        return Math.max(super.getAbilityWCooldown(), Math.max(this.lastAbilityQWETime + (long)Config.get(Config.sonaAbilityQWECooldown) - this.game.getTime(), 0L));
    }

    @Override
    public long getAbilityECooldown() {
        return Math.max(super.getAbilityECooldown(), Math.max(this.lastAbilityQWETime + (long)Config.get(Config.sonaAbilityQWECooldown) - this.game.getTime(), 0L));
    }

    @Override
    public void draw() {
        super.draw();
        if (this.isPowerChordWActive()) {
            ResourceManager.get().getGameWindow().drawText(GameWindow.FONT_SMALL, (int)this.x + this.getW() / 2, (int)this.y - 20, "Diminuendo: " + String.valueOf(Math.ceil((double)this.getPowerChordWTime() / 1000.0 * 10.0) / 10.0) + "s", 2);
        }
        if (this.isPowerChordEActive()) {
            ResourceManager.get().getGameWindow().drawText(GameWindow.FONT_SMALL, (int)this.x + this.getW() / 2, (int)this.y - (this.isPowerChordWActive() ? 35 : 20), "Tempo: " + String.valueOf(Math.ceil((double)this.getPowerChordETime() / 1000.0 * 10.0) / 10.0) + "s", 2);
        }
        if (this.lastAbilityWTime + 1000L - this.game.getTime() > 0L) {
            if (this.lastNoteAnimationTime == 0L || this.lastNoteAnimationTime + 100L < this.game.getTime()) {
                this.lastNoteAnimationTime = this.game.getTime();
                this.noteX1 = this.random.nextInt(10);
                this.noteX2 = this.random.nextInt(10);
                this.noteX3 = this.random.nextInt(10);
                this.noteY1 = this.random.nextInt(10);
                this.noteY2 = this.random.nextInt(10);
                this.noteY3 = this.random.nextInt(10);
            }
            this.abilityWParticle.draw((int)this.x + this.getW() / 2 - 0 - 30 - this.noteX1, (int)this.y - 48 - this.noteY1);
            this.abilityWParticle.draw((int)this.x + this.getW() / 2 - 8 - 50 - this.noteX2, (int)this.y - 0 - this.noteY2);
            this.abilityWParticle2.draw((int)this.x + this.getW() / 2 - 8 + 50 + this.noteX3, (int)this.y - 16 - this.noteY3);
        }
        if (this.isAbilityEActive()) {
            if (this.lastNoteAnimationTime == 0L || this.lastNoteAnimationTime + 100L < this.game.getTime()) {
                this.lastNoteAnimationTime = this.game.getTime();
                this.noteX1 = this.random.nextInt(10);
                this.noteX2 = this.random.nextInt(10);
                this.noteX3 = this.random.nextInt(10);
                this.noteY1 = this.random.nextInt(10);
                this.noteY2 = this.random.nextInt(10);
                this.noteY3 = this.random.nextInt(10);
            }
            this.abilityEParticle.draw((int)this.x + this.getW() / 2 - 0 - 30 - this.noteX1, (int)this.y - 48 - this.noteY1);
            this.abilityEParticle.draw((int)this.x + this.getW() / 2 - 8 - 50 - this.noteX2, (int)this.y - 0 - this.noteY2);
            this.abilityEParticle2.draw((int)this.x + this.getW() / 2 - 8 + 50 + this.noteX3, (int)this.y - 16 - this.noteY3);
        }
    }

    @Override
    protected void calculateHitbox() {
        this.hitbox.setBounds((int)this.x + 12, (int)this.y + 3, this.getW() - 24, this.getH() - 25);
    }

    @Override
    public void collidedWith(Entity other) {
        if (other instanceof EnemyCreatureEntity) {
            this.notifyDeath();
        }
    }

    public boolean isAbilityEActive() {
        return this.lastAbilityETime + (long)Config.get(Config.sonaAbilityEDuration) - this.game.getTime() > 0L;
    }

    @Override
    public void drawPauseMenuInfo() {
        GameWindow window = ResourceManager.get().getGameWindow();
        DecimalFormat f = new DecimalFormat("##0.0##");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        f.setDecimalFormatSymbols(dfs);
        this.passiveIconActive.draw(10, 70);
        this.abilityQIconActive.draw(10, 150);
        this.abilityWIconActive.draw(10, 210);
        this.abilityEIconActive.draw(10, 290);
        this.abilityRIconActive.draw(10, 360);
        this.abilityDIconActive.draw(10, 440);
        this.abilityFIconActive.draw(10, 520);
        window.drawText(GameWindow.FONT_SMALL, 50.0f, 55.0f, "Power Chord (Passive)\nAfter casting " + Config.get(Config.sonaAbilitiesPerPowerChord) + " spells, Sona's next attack has an additional effect depending on which spell was cast last.\nHer spells \"Hymn of Valor\", \"Aria of Perseverance\" and \"Song of Cerlerity\" will also set each other on cooldown for " + f.format((double)Config.get(Config.sonaAbilityQWECooldown) / 1000.0) + "s.");
        window.drawText(GameWindow.FONT_SMALL, 50.0f, 125.0f, "Hymn of Valor (Q) - Cooldown: " + f.format((double)Config.get(Config.sonaAbilityQCooldown) / 1000.0) + "s - " + f.format((double)Config.get(Config.sonaAbilityQCooldownPerLevel) / 1000.0) + "s per Level (currently: " + f.format((double)Math.max(Config.get(Config.sonaAbilityQCooldown) - Config.get(Config.sonaAbilityQCooldownPerLevel) * this.game.getLevel(), Config.get(Config.sonaAbilityQWECooldown)) / 1000.0) + "s) (This cooldown can not go below " + f.format((double)Config.get(Config.sonaAbilityQWECooldown) / 1000.0) + "s!)\nSona sends out two bolts of sound, dealing " + Config.get(Config.sonaAbilityQDamage) + " + " + Config.get(Config.sonaAbilityQDamagePerLevel) + " per level (currently: " + (Config.get(Config.sonaAbilityQDamage) + Config.get(Config.sonaAbilityQDamagePerLevel) * this.game.getLevel()) + ") damage to the first enemies they hit.\n(Power Chord) - Staccato: If this spell was last cast when Sona's Power Chord is read, her next attack will deal " + Config.get(Config.sonaPowerChordQDamage) + " additional damage.");
        window.drawText(GameWindow.FONT_SMALL, 50.0f, 195.0f, "Aria of Perseverance (W) - Cooldown: " + f.format((double)Config.get(Config.sonaAbilityWCooldown) / 1000.0) + "s\nSona sends out healing melodies, healing herself by " + Config.get(Config.sonaAbilityWHealAmount) + " + " + Config.get(Config.sonaAbilityWHealAmountPerLevel) + " per level (currently: " + (Config.get(Config.sonaAbilityWHealAmount) + Config.get(Config.sonaAbilityWHealAmountPerLevel) * this.game.getLevel()) + ").\n(Power Chord) - Diminuendo: If this spell was last cast when Sona's Power Chord is ready, Sona will receive " + f.format(100.0 - 100.0 * Config.get(Config.sonaPowerChordWMultiplier)) + "% less damage\nfor " + f.format((double)Config.get(Config.sonaPowerChordWDuration) / 1000.0) + " seconds.");
        window.drawText(GameWindow.FONT_SMALL, 50.0f, 265.0f, "Song of Celerity (E) - Cooldown: " + f.format((double)Config.get(Config.sonaAbilityECooldown) / 1000.0) + "s\nSona energizes herself with an burst of speed of " + f.format(Config.get(Config.sonaAbilityEMoveSpeedMultiplier) * 100.0 - 100.0) + "% + " + f.format(Config.get(Config.sonaAbilityEMoveSpeedMultiplierPerLevel) * 100.0) + "% per level (currently: " + f.format(Config.get(Config.sonaAbilityEMoveSpeedMultiplier) * 100.0 + Config.get(Config.sonaAbilityEMoveSpeedMultiplierPerLevel) * 100.0 * (double)this.game.getLevel() - 100.0) + "%) for " + f.format((double)Config.get(Config.sonaAbilityEDuration) / 1000.0) + " seconds." + "\n(Power Chord) - Tempo: If this spell was last cast when Sona's Power Chord is ready, her next attack will slow all enemies by " + f.format(100.0 - 100.0 * Config.get(Config.sonaPowerChordEMultiplier)) + "%\nfor " + f.format((double)Config.get(Config.sonaPowerChordEDuration) / 1000.0) + " seconds.");
        window.drawText(GameWindow.FONT_SMALL, 50.0f, 345.0f, "Crescendo (R) - Cooldown: " + f.format((double)Config.get(Config.sonaAbilityRCooldown) / 1000.0) + "s - " + f.format((double)Config.get(Config.sonaAbilityRCooldownPerLevel) / 1000.0) + "s per Level (currently: " + f.format((double)Math.max(Config.get(Config.sonaAbilityRCooldown) - Config.get(Config.sonaAbilityRCooldownPerLevel) * this.game.getLevel(), Config.get(Config.sonaAbilityRCooldownCap)) / 1000.0) + "s) (This cooldown can not go below " + f.format((double)Config.get(Config.sonaAbilityRCooldownCap) / 1000.0) + "s!)\nSona plays her ultimate chord, dealing " + Config.get(Config.sonaAbilityRDamage) + " + " + Config.get(Config.sonaAbilityRDamagePerLevel) + " per level (currently: " + (Config.get(Config.sonaAbilityRDamage) + Config.get(Config.sonaAbilityRDamagePerLevel) * this.game.getLevel()) + ") damage to all enemies it hits and stunning them and all minions\nfor " + f.format((double)Config.get(Config.sonaAbilityRStunDuration) / 1000.0) + "s + " + f.format((double)Config.get(Config.sonaAbilityRStunDurationPerLevel) / 1000.0) + "s per level (currently: " + f.format((double)Math.min(Config.get(Config.sonaAbilityRStunDuration) + Config.get(Config.sonaAbilityRStunDurationPerLevel) * this.game.getLevel(), Config.get(Config.sonaAbilityRStunDurationCap)) / 1000.0) + " seconds). (This stun duration can not go above " + f.format((double)Config.get(Config.sonaAbilityRStunDurationCap) / 1000.0) + "s!)");
        window.drawText(GameWindow.FONT_SMALL, 50.0f, 425.0f, "Heal (D) - Cooldown: " + f.format((double)Config.get(Config.sonaAbilityDCooldown) / 1000.0) + "s\nSona instantly restores " + Config.get(Config.sonaAbilityDHealAmount) + " + " + Config.get(Config.sonaAbilityDHealAmountPerLevel) + " per level (currently: " + (Config.get(Config.sonaAbilityDHealAmount) + Config.get(Config.sonaAbilityDHealAmountPerLevel) * this.game.getLevel()) + ") health.");
        window.drawText(GameWindow.FONT_SMALL, 50.0f, 505.0f, "Flash (F) - Cooldown: " + f.format((double)Config.get(Config.sonaAbilityFCooldown) / 1000.0) + "s\nSona teleports to a nearby location into the direction she is currently moving. (This ability can only be used while Sona is moving!)");
    }

    @Override
    public void drawIcons() {
        GameWindow window = ResourceManager.get().getGameWindow();
        this.passiveIcon = this.powerChordCount >= 3 ? this.passiveIconActive : this.passiveIconPassive;
        this.passiveIcon.draw(187, 560);
        if (this.powerChordCount > 0 && this.powerChordCount < Config.get(Config.sonaAbilitiesPerPowerChord)) {
            window.drawText(GameWindow.FONT_SMALL, 203.0f, 586.0f, "(" + this.powerChordCount + ")", 2);
        }
        this.abilityQIcon = this.isAbilityQOnCooldown() ? this.abilityQIconPassive : this.abilityQIconActive;
        this.abilityQIcon.draw(222, 560);
        window.drawText(GameWindow.FONT_SMALL, 238.0f, 586.0f, this.isAbilityQOnCooldown() ? String.valueOf(String.valueOf(Math.ceil((double)this.getAbilityQCooldown() / 1000.0 * 10.0) / 10.0)) + "s" : "Q", 2);
        this.abilityWIcon = this.isAbilityWOnCooldown() ? this.abilityWIconPassive : this.abilityWIconActive;
        this.abilityWIcon.draw(257, 560);
        window.drawText(GameWindow.FONT_SMALL, 273.0f, 586.0f, this.isAbilityWOnCooldown() ? String.valueOf(String.valueOf(Math.ceil((double)this.getAbilityWCooldown() / 1000.0 * 10.0) / 10.0)) + "s" : "W", 2);
        this.abilityEIcon = this.isAbilityEOnCooldown() ? this.abilityEIconPassive : this.abilityEIconActive;
        this.abilityEIcon.draw(292, 560);
        window.drawText(GameWindow.FONT_SMALL, 309.0f, 586.0f, this.isAbilityEOnCooldown() ? String.valueOf(String.valueOf(Math.ceil((double)this.getAbilityECooldown() / 1000.0 * 10.0) / 10.0)) + "s" : "E", 2);
        this.abilityRIcon = this.isAbilityROnCooldown() ? this.abilityRIconPassive : this.abilityRIconActive;
        this.abilityRIcon.draw(327, 560);
        window.drawText(GameWindow.FONT_SMALL, 344.0f, 586.0f, this.isAbilityROnCooldown() ? String.valueOf(String.valueOf(Math.ceil((double)this.getAbilityRCooldown() / 1000.0 * 10.0) / 10.0)) + "s" : "R", 2);
        this.abilityDIcon = this.isAbilityDOnCooldown() ? this.abilityDIconPassive : this.abilityDIconActive;
        this.abilityDIcon.draw(377, 560);
        window.drawText(GameWindow.FONT_SMALL, 394.0f, 586.0f, this.isAbilityDOnCooldown() ? String.valueOf(String.valueOf(Math.ceil((double)this.getAbilityDCooldown() / 1000.0 * 10.0) / 10.0)) + "s" : "D", 2);
        this.abilityFIcon = this.isAbilityFOnCooldown() ? this.abilityFIconPassive : this.abilityFIconActive;
        this.abilityFIcon.draw(412, 560);
        window.drawText(GameWindow.FONT_SMALL, 429.0f, 586.0f, this.isAbilityFOnCooldown() ? String.valueOf(String.valueOf(Math.ceil((double)this.getAbilityFCooldown() / 1000.0 * 10.0) / 10.0)) + "s" : "F", 2);
    }
}

